package com.digiwin.athena.semc.vo.common;

import lombok.*;
import org.hibernate.validator.constraints.Range;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @description: 业务授权关系 友情链接
 * @createDate: 2023/9/11
 * @author: sungqz
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class BizObjAuthRelBatchForLinkVo implements Serializable {

    private static final long serialVersionUID = 5361250685923277025L;

    /**
     * 应用列表
     */
    @Valid
    public List<AppAuthReq> appList;

    @Data
    public static class AppAuthReq {

        /**
         * 应用信息
         */
        @Valid
        private LinkAppVO linkAppReq;

        /**
         * 授权组织
         */
        @Valid
        private List<BizObjAuthRelVo> org;

        /**
         * 授权角色
         */
        @Valid
        private List<BizObjAuthRelVo> role;

        /**
         * 授权用户
         */
        @Valid
        private List<BizObjAuthRelVo> user;
    }

    @Data
    public static class LinkAppVO {
        /**
         * 应用主键id
         */
        @NotNull(message = "{NotNull.Folder.id}")
        private Long primaryId;

        /**
         * 应用类型：1:b/s应用 2:c/s应用 3:预设应用 4:雅典娜应用
         */
        @NotNull(message = "{NotNull.LinkAppVO.type}")
        @Range(min = 1, max = 4, message = "{Range.LinkAppVO.type}")
        private Integer bizObjSubType;
    }
}