package com.digiwin.athena.semc.vo.common;

import lombok.*;
import org.hibernate.validator.constraints.Range;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @description: 业务授权关系 组件
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class BizObjAuthRelBatchSystemReq implements Serializable {

    private static final long serialVersionUID = 6497000399827941640L;

    /**
     * 权限对象列表
     */
    @Valid
    @NotEmpty(message = "authList cannot be empty")
    private List<AuthVO> authList;

    /**
     * 组件列表
     */
    @Valid
    private List<LabelVO> labelList;

    /**
     * 权限
     */
    @Data
    public static class AuthVO {
        /**
         * 权限对象id
         */
        @NotNull(message = "{NotNull.BizObjAuthRelVo.authId}")
        private Long authId;

        /**
         * 权限类型：1.组织 2.角色 3.用户 5.部门
         */
        @NotNull(message = "{NotNull.BizObjAuthRelVo.authType}")
        private Integer authType;

        /**
         * 权限对象名称
         */
        @NotBlank(message = "{NotBlank.BizObjAuthRelVo.authName}")
        private String authName;
    }

    /**
     * 组件
     */
    @Data
    public static class LabelVO {
        /**
         * 组件id
         */
        @NotNull(message = "组件id不可为空")
        private Long labelId;



        /**
         * 是否关联，true：关联， false：未关联
         */
        private Boolean isRelated;

        /**
         * 组件类型（0：自定义组件、1：预设组件）
         */
        @NotNull(message = "组件类型不可为空")
        @Range(min = 0, max = 1, message = "组件类型为0或者1")
        private Integer labelType;
    }
}