package com.digiwin.athena.semc.vo.common;

import com.baomidou.mybatisplus.annotation.TableField;
import lombok.*;
import org.hibernate.validator.constraints.Range;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @description: 业务授权关系 组件
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class BizObjAuthRelBatchSystemVo implements Serializable {

    private static final long serialVersionUID = 6497000399827941640L;

    /**
     * 组件id
     */
    private Long labelId;

    /**
     * 组件类型（0：自定义组件、1：预设组件）
     */
    private Integer labelType;

    /**
     * 组件名称
     */
    private String labelName;

    /**
     * 预设组件名称-繁体
     */
    private String labelNameTw;


    /**
     * 有效状态 0:无效 1:有效
     */
    private Integer validStatus;

    /**
     * 是否需要卡死状态为有效（0：不需要；1：需要）
     */
    private Integer isEnableTrue;

    /**
     * 是否关联，true：关联， false：未关联
     */
    private Boolean isRelated=false;

    /**
     *  源应用数据来源 1:b/s 表 2:c/s 表 3:预设表 4:IAM接口
     */
    private String appName;


}