package com.digiwin.athena.semc.vo.common;

import lombok.*;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @description: 业务授权关系
 * @createDate: 2023/5/26 9:19
 * @author: sunyfa
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class BizObjAuthRelBatchVo implements Serializable {
    /** 单条或者多条业务主键 */
    @Valid
    @NotNull(message = "{NotNull.Folder.id}")
    private List<Long> ids;

    /** 授权组织 */
    @Valid
    private List<BizObjAuthRelVo> org;

    /** 授权角色 */
    @Valid
    private List<BizObjAuthRelVo> role;

    /** 授权用户 */
    @Valid
    private List<BizObjAuthRelVo> user;
}