package com.digiwin.athena.semc.vo.common;

import com.digiwin.athena.semc.entity.common.BizObjAuthRel;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.*;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @description: 业务授权关系
 * @createDate: 2023/5/26 9:19
 * @author: sunyfa
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
@AutoMapper(target = BizObjAuthRel.class)
public class BizObjAuthRelVo implements Serializable {
    /**
     * 业务对象id
     */
    private Long bizObjId;

    /**
     * 业务类型：1.帆软报表 2.友情链接应用管理
     */
    @NotNull(message = "{NotNull.BizObjAuthRelVo.bizObjType}")
    private Integer bizObjType;

    /**
     * 业务子类型：1:b/s应用 2:c/s应用 3:预设应用 4:雅典娜应用
     */
    private Integer bizObjSubType;

    /**
     * 权限对象id
     */
    @NotNull(message = "{NotNull.BizObjAuthRelVo.authId}")
    private Long authId;

    /**
     * 权限类型：1.组织 2.角色 3.用户
     */
    @NotNull(message = "{NotNull.BizObjAuthRelVo.authType}")
    private Integer authType;

    /**
     * 权限对象名称
     */
    @NotBlank(message = "{NotBlank.BizObjAuthRelVo.authName}")
    private String authName;
}