package com.digiwin.athena.semc.vo.common;

import lombok.*;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @description: 业务常用记录
 * @createDate: 2023/9/15
 * @author: sungqz
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class BizObjCommonUseVo implements Serializable {

    private static final long serialVersionUID = 4078707156561861421L;

    /**
     * 业务对象id
     */
    @NotBlank(message = "{NotNull.Folder.id}")
    private String primaryId;

    /**
     * 业务子类型 1:b/s应用 2:c/s应用 3:特殊应用 4:IAM应用
     */
    @NotNull(message = "{NotNull.LinkAppVO.type}")
    @Range(min = 1, max = 4, message = "{Range.LinkAppVO.type}")
    private Integer type;

    /**
     * 设置常用标识 true:设置常用 false:取消常用
     */
    @NotNull(message = "{NotNull.BizObjCommonUseVo.commonUseSet}")
    private Boolean commonUseSet;
}