package com.digiwin.athena.semc.vo.common;

import com.digiwin.athena.semc.entity.common.Folder;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.*;

import java.io.Serializable;
import java.util.List;

/**
 * @description: 通用目录树对象
 * @createDate: 2023/5/26 9:11
 * @author: sunyfa
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
@AutoMapper(target = Folder.class)
public class FolderViewVo implements Serializable {
    /** 主键 */
    private Long id;

    /** 目录名称 */
    private String name;

    /** 父目录标识 */
    private Long parentFolderId;

    /**
     * 目录层级 1:一级目录; 2:二级目录 3:三级目录
     */
    private Integer level;

    /** 目录顺序 */
    private Integer folderOrder;

    /** 目录下数据数量 */
    private Integer dataCount = 0;

    /** 子目录数量 */
    private Integer childCount = 0;

    /** 叶子节点 */
    private List<FolderViewVo> children;
}
