package com.digiwin.athena.semc.vo.common;

import com.baomidou.mybatisplus.annotation.TableField;
import com.digiwin.athena.semc.entity.common.Folder;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.*;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * @description: 通用目录树对象
 * @createDate: 2023/5/26 9:11
 * @author: sunyfa
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
@AutoMapper(target = Folder.class)
public class FolderVo implements Serializable {
    /** 主键 */
    private Long id;

    /** 目录名称 */
    @NotBlank(message = "{NotBlank.FolderVo.name}")
    @Size(max = 30, message = "{Size.FolderVo.name}")
    private String name;

    /** 父目录标识 */
    private Long parentFolderId;

    /**
     * 目录层级 1:一级目录; 2:二级目录 3:三级目录
     */
    private Integer level;
}
