package com.digiwin.athena.semc.vo.common;

import lombok.*;
import org.hibernate.validator.constraints.Range;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @description: 通用目录树对象
 * @createDate: 2023/5/26 9:11
 * @author: sunyfa
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class MoveFolderChildVo implements Serializable {

    /**
     * 目录id
     */
    @NotNull(message = "{NotNull.MoveFolderVo.id}")
    private Long id;

    /**
     * 父目录id
     */
    @NotNull(message = "{NotNull.MoveFolderVo.parentFolderId}}")
    private Long parentFolderId;

    /**
     * 目录层级 1:一级目录; 2:二级目录 3:三级目录
     */
    @NotNull(message = "{NotNull.FolderVo.level}")
    private Integer level;

    /**
     * 目录顺序
     */
    @NotNull(message = "{NotNull.MoveFolderVo.folderOrder}")
    private Integer folderOrder;

    /**
     * 子目录
     */
    @Valid
    private List<MoveFolderChildVo> children;
}
