package com.digiwin.athena.semc.vo.common;

import lombok.*;
import org.hibernate.validator.constraints.Range;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @description: 通用目录树对象
 * @createDate: 2023/5/26 9:11
 * @author: sunyfa
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class MoveFolderVo implements Serializable {

    /**
     * 目录id
     */
    @NotNull(message = "{NotNull.MoveFolderVo.id}")
    private Long id;

    /**
     * 目录顺序
     */
    @NotNull(message = "{NotNull.MoveFolderVo.folderOrder}")
    private Integer folderOrder;

    /**
     * 目录层级 1:一级目录; 2:二级目录 3:三级目录
     */
    @NotNull(message = "{NotNull.FolderVo.level}")
    @Range(min = 1, max = 3, message = "{Range.FolderVo.level}")
    private Integer level;

    /**
     * 子目录
     */
    @Valid
    private List<MoveFolderChildVo> children;
}
