package com.digiwin.athena.semc.vo.common;

import lombok.*;

import java.io.Serializable;
import java.util.List;

/**
 * @description 用户授权的商品信息
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class UserApplicationDTO implements Serializable {

    private static final long serialVersionUID = -7613933053020695424L;

    /**
     *  id
     */
    private String id;

    /**
     * 租户名称
     */
    private String tenantName;

    /**
     * 商品名称
     */
    private String name;

    /**
     * 过期时间
     */
    private String expiredTime;

    /**
     * 是否过期 false：没有过期 true：过期
     */
    private Boolean expired = Boolean.TRUE;

    /**
     * 模组信息集合
     */
    private List<UserApplicationModulesDTO> enabledModules;

}
