package com.digiwin.athena.semc.vo.common;

import com.baomidou.mybatisplus.annotation.TableField;
import lombok.*;

import java.io.Serializable;

/**
 * @description: 首页用户组件
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class UserSystemLabelVo implements Serializable {

    private static final long serialVersionUID = 6497000399827941640L;

    /**
     * 组件id
     */
    private Long labelId;

    /**
     * 组件类型（0：自定义组件、1：预设组件）
     */
    private Integer labelType;

    /**
     * 组件名称
     */
    private String labelName;


    /**
     * 组件展示位置
     */
    private Integer labelIndex;


    /**
     * 数据类型（0：待办、1：三方报表、2：新闻公告、3：邮件、
     * 4：常用、5：收藏、6：全局资讯、7：绩效、8：作业工作台、9：行事历）
     */
    private Integer dataType;

    /**
     * 图标
     */
    private String icon;

    /**
     * 组件分类（ 0-预设组件-三方待办、1-预设组件-三方报表、2-预设组件-新闻公告、
     * 3-自定义组件-作业集成、4-自定义组件-应用集成、5-预设组件-固定组件；6-自定义组件-统计； 7-自定义组件-统计）
     */
    private Integer dataCategory;

    /**
     * 展示方式（ 0：文本列表、1：应用、2：应用作业）
     */
    private Integer showType;


    /**
     * 有效状态 0:无效 1:有效
     */
    private Integer validStatus;

}