package com.digiwin.athena.semc.vo.event;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class PageQueryEventTrackingVO {
    /**
     * 创建时间
     */
    @ColumnWidth(25)
    @ExcelProperty(index = 0, value = "创建时间")
    private String createTime;

    /**
     * 用户名称
     */
    @ColumnWidth(20)
    @ExcelProperty(index = 1, value = "用户名称")
    private String userNameAndId;

    /**
     * 操作类型（这里返回是操作类型的描述）
     */
    @ColumnWidth(20)
    @ExcelProperty(index = 2, value = "操作类型")
    private String eventDesc;

    /**
     * 操作类型
     */
    @ExcelIgnore
    private Integer eventType;

    /**
     * 操作详情
     */
    @ColumnWidth(40)
    @ExcelProperty(index = 3, value = "操作详情")
    private String eventName;
}
