package com.digiwin.athena.semc.vo.homepage;

import lombok.*;

import java.util.List;

/**
 * @description: 版更详情对象
 * @createDate: 2023/8/2
 * @author: sungqz
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class UpgradeInfoDetailResp {
    /**
     * 标题
     */
    private String title;

    /**
     * 版本号
     */
    private String deployNote;

    /**
     * 版更时间
     */
    private String updateTime;

    /**
     * 版更详情
     */
    private List<UpgradeInfoDetailVO> details;

    /**
     * 版更详情
     */
    @Data
    public static class UpgradeInfoDetailVO {
        /**
         * 版更内容标题
         */
        private String title;

        /**
         * 版更内容详情
         */
        private List<ContentVO> content;
    }

    /**
     * 版更内容详情
     */
    @Data
    public static class ContentVO {

        /**
         * 文字说明
         */
        private String text;

        /**
         * 图片
         */
        private List<DetailFile> picture;

        /**
         * 视频
         */
        private List<DetailFile> video;

        /**
         * 附件
         */
        private List<DetailFile> attachment;
    }

    /**
     * 详情文件说明 图片/视频/附件对象
     */
    @Data
    public static class DetailFile {
        /**
         * 文件id
         */
        private String fileId;

        /**
         * 文件名称
         */
        private String name;

        /**
         * 文件url
         */
        private String url;

        /**
         * 文件类型
         */
        private String type;
    }
}
