package com.digiwin.athena.semc.vo.maycur;

import lombok.*;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;

/**
 * 每刻报销待办回调外调参数
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class MaycurCalloutParamsReq implements Serializable {

    /** 企业编号 */
    private String  entCode;

    /** 单据号 */
    private String formCode;

    /** 单据内码 */
    private String formDataCode;

    /**
     * 单据名称-报销事由
     */
    private String formName;

    /**
     * 单据类型
     * PRECONSUME 消费申请
     * REIMBURSE 普通报销
     * CORP_REIMBURSE 对公报销
     * CORP_CONTRACT 采购合同
     * CORP_REPAYMENT对公收款
     * REPAYMENT还款单
     */
    private String formType;

    /**
     * 单据小类
     */
    private String formSubType;

    /**
     * 提交人-提交人工号
     */
    private String submitter;

    /**
     * 提交人姓名
     */
    private String submitterName;

    /**
     * 报销人工号
     */
    private String reimUser;

    /**
     * 报销人姓名
     */
    private String reimUserName;

    /**
     * 审批意见
     */
    private String reason;

    /**
     * 流程任务ID
     */
    private String procInsId;

    /**
     * 事件场景
     * APPROVAL 审批;
     * CASHIER_SETTLE 结算;
     * FINANCE_AUDIT 审核
     */
    private String eventScenario;


    /**
     * 任务号
     */
    private String taskId;


    /**
     * 任务类型
     * PROCESSING 待处理
     * COMPLETED 完成
     * REJECTED 驳回
     * REJECTED_TO_PREVIOUS 驳回到之前的任务处理人
     * RECALLED 召回
     * FORWARD 转发
     * REVERTED 撤回
     * DELEGATE 转派
     * COUNTERSIGN 加签
     * DELETE 删除
     * PROCESS_COMPLETED 流程完成
     * BE_REJECTED 驳回提单人
     * CARBON_COPY 抄送
     * 任务类型实际上只有两种，待处理和已完成，待处理即PROCESSING，
     * 已完成包括COMPLETED、REJECTED、REJECTED_TO_PREVIOUS、RECALLED、FORWARD、REVERTED、CARBON_COPY这7种
     */
    private String taskActionType;


    /**
     * 任务处理人 -工号，（组下工号列表
     */
    private List<String> taskAssignee;


    /**
     * 事件发生时间
     */
    private String eventTime;


    /**
     * 分摊编码
     */
    private String allocationCode;

    /**
     * 任务处理人userCode
     */
    private List<String> assigneUserCodes;


}
