package com.digiwin.athena.semc.vo.menu;

import com.digiwin.athena.semc.entity.menu.CustomizedMenuWork;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.*;

import java.io.Serializable;
import java.util.List;

/**
 * 自定义菜单树返回对象
 *
 * @author sungqz
 * @since 2023-11-10
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
@ToString
@AutoMapper(target = CustomizedMenuWork.class)
public class CustomizedMenuWorkResp implements Serializable {
    private static final long serialVersionUID = -6657832112681720113L;
    /**
     * 主键id
     */
    private Long id;

    /**
     * 菜单图标
     */
    private String menuIcon;

    /**
     * 菜单/作业/组件名称
     */
    private String menuName;

    /**
     * 菜单/作业/组件名称 繁体
     */
    private String menuNameTw;

    /**
     * 菜单/作业/组件初始名称（暂时不用）
     */
    private String originalName;

    /**
     * 类型 1:菜单 2:作业 3：组件
     */
    private Integer menuType;
    /**
     * 部件类型来源，0：租户部件，1：ISV部件
     */
    private Integer labelTypeSource;
    /**
     * 组件id
     */
    private Long menuLabelId;

    /**
     * 组件类型 0：自定义组件 1：预设组件
     */
    private Integer menuLabelType;

    /**
     * 预设组件类型 2：新闻公告、3：邮件、4：常用、5：收藏、6：数智视图、7：绩效、8：作业工作台、9：行事历
     */
    private Integer preLabelDataType;

    /**
     * 应用作业配置
     */
    private String workConfig;

    /**
     * 层级 1:一级 2:二级 3:三级
     */
    private Integer level;

    /**
     * 顺序
     */
    private Integer menuOrder;

    /**
     * 父级id
     */
    private Long parentId;

    /**
     * 父级名称
     */
    private String parentName;

    /**
     * 作业code
     */
    private String appCode;

    /**
     * 子菜单列表
     */
    private List<CustomizedMenuWorkResp> children;
}