package com.digiwin.athena.semc.vo.menu;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * 用户管理菜单 标识 返回对象
 *
 */
@Data
public class UserManageMenulVO implements Serializable {

    private static final long serialVersionUID = 1295563588708518333L;

    /**
     *  是否有菜单 false：没有 true：有
     */
    private Boolean isHaveMenu;

    /**
     * 所属环境标识 0:全部 1:云上 2:下地
     */
    @NotNull(message = "environmentFlag cannot be empty")
    private Integer environmentFlag;

    /**
     * 菜单key，每个菜单项的唯一标识符
     */
    private String menuKey;
}