package com.digiwin.athena.semc.vo.message;

import lombok.*;

import java.io.Serializable;

/**
 * 消息所属应用
 *
 * @author sungqz
 * @since 2025-06-25
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class MessageAppNumResp implements Serializable {

    private static final long serialVersionUID = -7499625286802797174L;

    /**
     * 应用appId
     */
    private String appId;

    /**
     * 应用名称
     */
    private String appName;

    /**
     * 消息总数
     */
    private Long sumNum;

    /**
     * 消息未读数
     */
    private Long unReadNum;

    /**
     * 消息已读数
     */
    private Long readNum;

    /**
     * 应用顺序
     */
    private Integer appSort;

    /**
     * 显示该分类下最新消息的内容
     */
    private String latestMessageContent;

    /**
     * 显示该分类下最新消息的发送时间
     */
    private String latestMessageModifyTime;
}