package com.digiwin.athena.semc.vo.mobile;

import com.digiwin.athena.semc.entity.mobile.MobilePortalInfoContent;

import io.github.linpeilie.annotations.AutoMapper;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@AutoMapper(target = MobilePortalInfoContent.class)
public class BallResp {
    /**
     * 金刚球名称
     */
    private String ballName;

    /**
     * 金刚球跳转类型（0-常用功能、1-自定义链接、2：应用/作业、3：自定义页面、4：公告 5、公告类型_0表示全部公告）
     */
    private Integer jumpType;

    /**
     * 跳转目标（pageID的值 或者 链接地址 或者自定义页面ID 或者公告ID 或者公告类型ID）
     */
    private String jumpTarget;

    /**
     * 金刚球图标
     */
    private String contentIcon;

    /**
     * 金刚球图标类型 0:模板库 1:本地上传
     */
    private Integer iconType;

    /**
     * 金刚球跳转链接
     */
    private String iconUrl;

    /**
     * 自定义应用id
     */
    private Long customApplicationId;

    /**
     * 回调地址
     */
    private String callBackUrl;

    /**
     * 注册的url
     */
    private String registerUrl;

    /**
     * 注册的appCode
     */
    private String applicationPrimaryId;

    /**
     * 创建人id
     */
    private String createUserId;
}
