package com.digiwin.athena.semc.vo.mobile;

import com.digiwin.athena.semc.entity.mobile.MobileApplicatonColumn;

import java.util.List;
import java.util.Map;

import io.github.linpeilie.annotations.AutoMapper;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@AutoMapper(target = MobileApplicatonColumn.class)
public class MobileAppColumnResp {

    private Long id;

    /**
     * 上级id
     */
    private Long parentId;

    /**
     * 名称
     */
    private String name;

    /**
     * 状态：0：停运、1：启用
     */
    private Integer status;

    /**
     * 排序id
     */
    private Integer orderId;

    /**
     * 自定义应用id
     */
    private String customApplicationId;

    /**
     * 租户id
     */
    private String tenantId;

    /**
     * 是否展示名称
     */
    private Integer isNameShow;

    /**
     * 自定义应用集合
     */
    private List<MobileDatasourceInfoVO> mobileCustomAppList;

    /**
     * 自定义id和类型集合以及模组
     */
    private List<Map> idAndSources;

}
