package com.digiwin.athena.semc.vo.mobile;

import com.digiwin.athena.semc.entity.mobile.MobileDataSourceAuth;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.*;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @description:  应用/作业 权限保存入参
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
@AutoMapper(target = MobileDataSourceAuth.class)
public class MobileDataSourceAuthSaveReq implements Serializable {

    private static final long serialVersionUID = 6497000399827941640L;

    /**
     * 权限对象id
     */
    @NotBlank(message = "权限对象id不可为空")
    private String authId;

    /**
     * 权限对象sid
     */
    @NotNull(message = "权限对象sid不可为空")
    private Long authSid;

    /**
     * 权限类型：1.组织 2.角色 3.用户
     */
    @NotNull(message = "权限类型不可为空")
    private Integer authType;

    /**
     * 权限对象名称
     */
    @NotBlank(message = "权限对象名称不可为空")
    private String authName;

    /**
     * 应用作业集合
     */
    public List<MobileDataSourceAuthListResp>  dataSourceList;

}