package com.digiwin.athena.semc.vo.mobile;


import com.baomidou.mybatisplus.annotation.TableField;
import com.digiwin.athena.semc.entity.mobile.MobileDatasourceInfo;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;

import java.io.Serializable;

/**
 * 移动应用/作业管理返回对象
 *
 * @author qutong
 * @since 2024-09-04
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ToString
@AutoMapper(target = MobileDatasourceInfo.class)
public class MobileDatasourceInfoVO implements Serializable {

    private static final long serialVersionUID = 8948094675365734665L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 名称
     */
    private String name;

    /**
     * 图标
     */
    private String icon;

    /**
     * 图标url
     */
    private String iconUrl;

    /**
     * 图标类型 0-图标库 1-自定义图标
     */
    private Integer iconType;

    /**
     * 状态 0:未发布 1:已发布 2:已失效
     */
    private Integer status;

    /**
     * 分类id
     */
    private Long classificationId;

    /**
     * 分类名称
     */
    private String classificationName;

    /**
     * 类型 1-第三方应用/作业 2-鼎捷非雅典娜新应用 3-鼎捷雅典娜应用
     */
    private Integer type;

    /**
     * 类型名称
     */
    private String typeName;

    /**
     * 备注
     */
    private String remarks;

    /**
     * sso应用主键id
     */
    private String applicationPrimaryId;

    /**
     * 应用id
     */
    private String appCode;

    /**
     * sso应用数据来源 1:b/s 表 2:c/s 表 3:预设表 4:IAM接口
     */
    private Integer applicationSource;

    /**
     * sso应用名称
     */
    private String applicationSourceName;

    /**
     * 创建日期
     */
    protected String createTime;

    /**
     * 更新日期
     */
    protected String modifyTime;

    /**
     * 创建者登录账号
     */
    protected String createUserId;

    /**
     * 更新者登录账号
     */
    protected String modifyUserId;

    /**
     *  是否需要自定义作业（0：不需要；1：需要）
     */
    private Integer isJob;

    /**
     * 作业回调地址
     */
    private String callBackUrl;

    /**
     * 注册时的url
     */
    private String registerUrl;

    /**
     * 作业code
     */
    private String workCode;

    /**
     * 作业名称
     */
    private String workName;

    private String modifyUserName;

    private String createUserName;

    /**
     * 应用配置（SSO配置）
     */
    private String applicationConfig;


    /**
     * 特殊标识：1-绿色智机 2-每刻
     */
    private Integer specialSign;

    /**
     * iam关联商品id
     */
    private String iamApplicationId;

    /**
     * iam关联模组id
     */
    private String iamModuleId;

    /**
     * iam关联作业id
     */
    private String iamWorkId;

    /**
     * 是否有权限 false：无 true：有
     */
    private Boolean authFlag = Boolean.TRUE;


    /**
     * 是否已经添加过 0:未添加 1:已添加
     */
    private int isAdd;
}

