package com.digiwin.athena.semc.vo.mobile;

import com.digiwin.athena.semc.dto.mobile.*;
import com.digiwin.athena.semc.entity.mobile.MobilePortalInfoContent;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotNull;
import java.util.List;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@AutoMapper(target = MobilePortalInfoContent.class)
public class MobilePortalInfoContentResp {

    /**
     * 栏目id
     */
    private Long columnId;

    /**
     * 部件类型来源，0：租户部件，1：ISV部件
     */
    private Integer labelTypeSource;

    /**
     * 组件ID
     */
    @NotNull(message = "金刚区组件id不能为空")
    private Long contentId;

    /**
     * 组件类型（0-预设组件-金刚区、1-预设组件-任务组件、2-预设组件-项目追踪组件、3-金刚球）
     */
    @Range(min = 0, max = 3, message = "超出目标范围")
    private Integer contentType;

    /**
     * 父组件id
     */
    private Long parentId;

    /**
     * 内容组件名称
     */
    private String contentName;

    /**
     * 金刚球图标
     */
    private String contentIcon;

    /**
     * 内容uuid
     */
    private String contentUuid;

    /**
     * 金刚球跳转类型（0-常用功能、1-自定义链接、3-自定义应用SSO 4：公告 5、公告类型_0表示全部公告）
     */
    private Integer jumpType;

    /**
     * 金刚球跳转目标（pageID的值 或者 链接地址 或者自定义页面ID 或者 公告ID 或者 公告类型ID）
     */
    private String jumpTarget;

    /**
     * 栏目标题
     */
    private String title;

    /**
     * 是否展示标题
     */
    private Integer isTitleShow;

    /**
     * 是否显示文字（0：隐藏，1：显示）
     */
    private Integer isNameShow;

    /**
     * 0:默认 租户自定义类型，展示原来的金刚区,1:用户自定义类型
     */
    private Integer interactionType;

    /**
     *0:默认 租户自定义类型，展示原来的金刚区,1:用户自定义类型
     */
    private Integer customType;

    /**
     * 列数
     */
    private Integer columnNum;

    /**
     * 行数
     */
    private Integer lineNum;


    /**
     * 金刚球
     */
    private List<BallResp> ballList;

    /**
     * 组件内容属性值json
     */
    private String contentAttr;

    /**
     * 公告信息
     */
    private MobilePortalContentNews newsInfo;


    /**
     * 轮播图信息
     */
    private MobilePortalContentCarousel carouselInfo;

    /**
     * 标题组件信息
     */
    private MobilePortalTitleInfoReqDTO titleInfo;

    /**
     * 分割线信息
     */
    private MobilePortalDividerInfoReqDTO dividerInfo;

    /**
     * 图片组件
     */
    private MobilePortalImageInfoReqDTO imageCompInfo;


    /**
     * 业务入口组件
     */
    private MobilePortalBusinessInfoReqDTO businessCompInfo;
}
