package com.digiwin.athena.semc.vo.mobile;

import com.baomidou.mybatisplus.annotation.TableField;
import com.digiwin.athena.semc.entity.mobile.MobilePortalInfo;

import io.github.linpeilie.annotations.AutoMapper;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 移动门户列表
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@AutoMapper(target = MobilePortalInfo.class)
public class MobilePortalInfoItemResp {

    /**
     * 门户id
     */
    private Long id;

    /**
     *门户名称
     */
    private String name;

    /**
     * 默认门户（ 0：否 1：是）
     */
    private Integer defaultFlag;

    /**
     * 是否是最近打开的门户；true：是、false：否
     */
    private Boolean isRecently;

    /**
     *最近选择的门户权限不存在时提示信息，为空说明有权限或者第一次使用
     */
    private String recentlyMsg;

    /**
     * 老门户版本为0 默认门户版本为1
     */
    @TableField(exist = false)
    private int versionDefault;
}
