package com.digiwin.athena.semc.vo.mobile;


import com.digiwin.athena.semc.entity.mobile.MobilePortalInfo;
import com.digiwin.athena.semc.entity.mobile.MobilePortalPreview;

import java.util.List;

import io.github.linpeilie.annotations.AutoMapper;
import io.github.linpeilie.annotations.AutoMappers;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@AutoMappers({
        @AutoMapper(target = MobilePortalInfo.class),
        @AutoMapper(target = MobilePortalPreview.class)
})
public class MobilePortalInfoResp {

    /**
     * 主键id
     */
    private Long id;

    /**
     * 默认门户（ 0：否 1：是）
     */
    private Integer defaultFlag;

    /**
     * 门户类型（0：门户布局；1：自定义页面布局）
     */
    private Integer portalType;


    /**
     * 自定义页面标题
     */
    private String title;


    /**
     * 自定义页面背景色
     */
    private String bgColor;

    /**
     * 门户名称
     */
    private String name;

    /**
     * 布局描述
     */
    private String portalDesc;

    /**
     * 布局状态（0：未发布；1：已发布
     */
    private Integer status;

    /**
     * 布局内容
     */
    private String portalContent;

    /**
     * 缩略图文件id
     */
    private String portalImgId;

    /**
     * 租户id
     */
    private String tenantId;

    /**
     * 更新者登录账号
     */
    private String modifyUserId;


    /**
     * 创建日期
     */
    protected String createTime;

    /**
     * 更新日期
     */
    private String modifyTime;


    /**
     * 权限被收回提示
     */
    private String recentlyMsg;

    /**
     * 创建者登录账号
     */
    protected String createUserId;

    /**
     * 创建者登录名称
     */
    private String createUserName;

    /**
     * 更新者登录名称
     */
    private String modifyUserName;

    /***
     * 组件
     */
    private List<MobilePortalInfoContentResp> contentList;


    /**
     * 老门户版本为0 默认门户版本为1
     */
    private int versionDefault;
}
