package com.digiwin.athena.semc.vo.module;

import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.*;

import java.io.Serializable;
import java.util.List;

/**
 * @description: 模组信息
 * @createDate: 2025/8/25 16:45
 * @author: lilliaancheng
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class ModuleOrderVo implements Serializable {
    /** 模组编码 */
    private String code;

    /**
     * 模组類型　APP_CODE:应用; GROUP_CODE:群组; ITEM_CODE作业;
     */
    private String codeType;

    /** 模组名称 */
    private String name;

    /** 下层模组 */
    @JsonInclude(JsonInclude.Include.NON_NULL)
    List<ModuleOrderVo> groupList;
}
