package com.digiwin.athena.semc.vo.news;

import com.digiwin.athena.semc.entity.news.NewsAnnouncementType;

import java.util.List;

import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;

@Data
@AutoMapper(target = NewsAnnouncementType.class)
public class NewsAnnouncementTypeVO {
    /**
     * 主键id
     */
    private Long id;

    /**
     * 公告类型标题
     */
    private String name;

    /**
     * 公告类型标题-繁体
     */
    private String nameTw;

    /**
     * 公告类型层级
     */
    private Integer level;

    /**
     * 公告类型顺序
     */
    private Integer sort;

    /**
     * 公告总数
     */
    private Integer newsCount;

    /**
     * 已发布公告总数
     */
    private Integer publishedNewsCount;

    /**
     * 有权限的公告总数
     */
    private Integer authNewsCount;

    /**
     * 有权限的公告未读数
     */
    private Integer authUnReadNewsCount;


    /**
     * 父类型id
     */
    private Long parentId;

    /**
     * 父类型名称
     */
    private String parentName;

    /**
     * 公告类型说明
     */
    private String description;

    /**
     * 公告类型说明-繁体
     */
    private String descriptionTw;

    /**
     * 默认类型 0:否 1:是
     */
    private Integer defaultFlag;

    /**
     * 租户id
     */
    private String tenantId;

    /**
     * 是否是"其他"类型 false：否 true：是
     */
    private Boolean otherFlag = Boolean.FALSE;

    /**
     * 公告类型子集
     */
    private List<NewsAnnouncementTypeVO> childrenList;
}
