package com.digiwin.athena.semc.vo.news;

import com.digiwin.athena.semc.entity.news.NewsAnnouncement;
import com.digiwin.athena.semc.proxy.iam.service.model.UserDTO;
import com.digiwin.athena.semc.vo.auth.AuthVO;
import com.digiwin.athena.semc.vo.file.FileInfoVO;

import java.io.Serializable;
import java.util.List;

import io.github.linpeilie.annotations.AutoMapper;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * 新闻公告表(TNewsAnnouncement)返回对象
 *
 * @author sunqgz
 * @since 2024-05-14
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ToString
@AutoMapper(target = NewsAnnouncement.class)
public class NewsAnnouncementVO implements Serializable {

    private static final long serialVersionUID = 8948094675365734665L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 公告标题
     */
    private String newsTitle;

    /**
     * 公告状态 0:未发布 1:已发布 2:已失效 3:待生效(该状态在代码中体现)
     */
    private Integer newsStatus;

    /**
     * 公告生效时间类型 0:立即生效 1:定时生效
     */
    private Integer newsEffectiveFlag;

    /**
     * 公告生效时间
     */
    private String newsEffectiveTime;

    /**
     * 公告截止时间
     */
    private String newsEndTime;

    /**
     * 公告类型id
     */
    private Long newsTypeId;

    /**
     * 父级公告类型id
     */
    private Long parentNewsTypeId;

    /**
     * 公告类型名称
     */
    private String newsTypeName;

    /**
     * 公告摘要
     */
    private String summary;

    /**
     * 公告渠道标识 0:全部 1:Web工作台 2:移动工作台
     */
    private Integer newsChannel;

    /**
     * 封面图默认icon
     */
    private String defaultImageIcon;

    /**
     * 封面图文件信息
     */
    private FileInfoVO coverImageInfo;

    /**
     * 是否置顶 0:否 1:是
     */
    private Integer toppedFlag;

    /**
     * 公告置顶时间
     */
    private String toppedTime;

    /**
     * 是否修改 0:否 1:是
     */
    private Integer modifiedFlag;

    /**
     * 是否发送工作提醒 0：否 1：是
     */
    private Integer noticeFlag;

    /**
     * 公告正文
     */
    private String newsContent;

    /**
     * 附件列表
     */
    private List<FileInfoVO> fileList;

    /**
     * 全员可见 0:否 1:是
     */
    private Integer allAuthFlag;

    /**
     * 点赞数量
     */
    private Integer likeCount;

    /**
     * 是否点赞 true:点赞 false:未点赞
     */
    private Boolean likeFlag;


    /**
     * 点赞人员集合
     */
    private List<UserDTO> likeList;

    /**
     * 收藏数
     */
    private Integer favoriteCount;

    /**
     * 是否收藏 true:收藏 false:未收藏
     */
    private Boolean favoriteFlag;


    /**
     * 已读人员数量
     */
    private Integer readCount;

    /**
     * 已读人员信息
     */
    private List<UserDTO> readList;

    /**
     * 未读人员数量
     */
    private Integer unReadCount;

    /**
     * 未读人员信息
     */
    private List<UserDTO> unReadList;

    /**
     * 应读人员数量
     */
    private Integer shouldReadCount;

    /**
     * 应读人员信息
     */
    private List<UserDTO> shouldReadList;

    /**
     * 授权组织
     */
    private List<AuthVO> orgList;

    /**
     * 授权角色
     */
    private List<AuthVO> roleList;

    /**
     * 授权部门
     */
    private List<AuthVO> deptList;

    /**
     * 授权用户
     */
    private List<AuthVO> userList;

    /**
     * 授权用户
     */
    private List<AuthVO> externalUserList;

    /**
     * 是否已读 true:已读 false:未读
     */
    private Boolean readFlag;

    /**
     * 三方公告id
     */
    private String thirdNewsId;

    /**
     * 三方应用id
     */
    private String thirdAppId;

    /**
     * 三方应用code
     */
    private String thirdAppCode;

    /**
     * 三方应用名称
     */
    private String thirdAppName;

    /**
     * 三方域名
     */
    private String thirdUrl;

    /**
     * 三方图片url
     */
    private String thirdImgUrl;

    /**
     * 三方人员通知列表 如  emp001.emp002
     */
    private String thirdUserIds;

    /**
     * 三方公告网页url
     */
    private String thirdNewsHtml;

    /**
     * 公告来源 0：一方 1：三方
     */
    private Integer newsSource;

    /**
     * 注册应用时生成的appId
     */
    private String applicationAppId;

    /**
     * 消息来源应用名称
     */
    private String messageAppName;

    /**
     * 回调地址
     */
    private String callBackUrl;

    /**
     * 协议类型 1、oauth2.0 2、cas
     */
    private Integer protocolType;

    /**
     * appToken
     */
    private String appToken;

    /**
     * flag =0 代表截止时间小于当前 ，flag = 1 代表 等于截止时间 flag = 2 代表截止时间大于当前
     */
    private Integer flag;

    /**
     * 创建日期
     */
    private String createTime;

    /**
     * 更新日期
     */
    private String modifyTime;

    /**
     * 创建者账号
     */
    private String createUserId;

    /**
     * 创建者名称
     */
    private String createUserName;

    /**
     * 更新者账号
     */
    private String modifyUserId;

    /**
     * 更新者名称
     */
    private String modifyUserName;

    /**
     * 发布人类型，1（无）， 2（发布人姓名） 3（发布人角色）
     */
    private Integer publishType;

    /**
     * 发布人id（当publishType为3时必填）
     */
    private String publishId;


    /**
     * 发布人姓名
     */
    private String publishName;
}

