package com.digiwin.athena.semc.vo.news;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;

import java.io.Serializable;

/**
 * 新增/编辑公告校验 请求入参
 *
 * @author sunqgz
 * @since 2025-1-13
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class ValidSaveNewsTypeVO implements Serializable {

    private static final long serialVersionUID = -4454772167044558717L;

    /**
     * 返回错误码
     * 1000：校验通过
     * 1001：当前公告类型不存在
     * 1002：当前公告类型已经包含子级，仅可作为一级类型
     * 1003：一级公告类型不能超过30个
     * 1004：所属父级类型不存在
     * 1005：所属父级类型不能包含公告
     * 1006：所属父级下的二级公告类型不能超过30个
     * 1007：当前公告类型包含数据，不可添加子级
     * 1008：当前公告类型的子级已达上限
     * 1009：当前公告的所属类型无权操作，请刷新后再试
     * 1010：所选公告的所属类型，部分无权操作，请刷新后再试
     * 1011：不可选择一级公告类型，请重新选择
     * 1012：公告类型无权限，请重新选择
     * 1013：当前一级公告类型已包含二级类型，请重新选择
     */
    private String msgCode;
}

