package com.digiwin.athena.semc.vo.portal;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.*;

import java.io.Serializable;

/**
 * @description: 帆软报表导出excel
 * @createDate: 2023/8/16
 * @author: sungqz
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
@ToString
@AutoMapper(target = FineReportVo.class)
public class ExportExcelVo implements Serializable {

    /**
     * 报表名称
     */
    @ColumnWidth(20)
    @ExcelProperty(index = 0, value = "报表名称")
    private String name;

    /**
     * 描述
     */
    @ColumnWidth(20)
    @ExcelProperty(index = 1, value = "描述")
    private String comments;

    /**
     * 报表链接
     */
    @ColumnWidth(20)
    @ExcelProperty(index = 2, value = "报表链接")
    private String url;

    /**
     * 报表顺序
     */
    @ColumnWidth(20)
    @ExcelProperty(index = 3, value = "排序")
    private Integer reportOrder;

    /**
     * 角色权限
     */
    @ColumnWidth(20)
    @ExcelProperty(index = 4, value = "选择角色")
    private String authRel;

    /**
     * 一级目录名称
     */
    @ColumnWidth(20)
    @ExcelProperty(index = 5, value = "报表1级目录")
    private String firstFolderName;

    /**
     * 二级目录名称
     */
    @ColumnWidth(20)
    @ExcelProperty(index = 6, value = "报表2级目录")
    private String secondFolderName;

    /**
     * 三级目录名称
     */
    @ColumnWidth(20)
    @ExcelProperty(index = 7, value = "报表3级目录")
    private String thirdFolderName;
}