package com.digiwin.athena.semc.vo.portal;


import com.digiwin.athena.semc.entity.portal.FineReport;
import com.digiwin.athena.semc.vo.common.BizObjAuthRelVo;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;
import org.hibernate.validator.constraints.Range;


import javax.validation.Valid;
import javax.validation.constraints.*;
import java.io.Serializable;
import java.util.List;

/**
 * @description: 帆软报表对象
 * @createDate: 2023/5/26 9:17
 * @author: sunyfa
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
@ToString
@AutoMapper(target = FineReport.class)
public class FineReportVo implements Serializable {
    /** 主键 */
    private Long id;

    /** 报表名称 */
    @NotBlank(message = "{NotBlank.FineReportVo.name}")
    @Size(max = 50, message = "{Size.FineReportVo.name}")
    private String name;

    /** 报表链接 */
    @NotBlank(message = "{NotBlank.FineReportVo.url}")
    @Size(max = 500, message = "{Size.FineReportVo.url}")
    private String url;

    /** 描述 */
    @Size(max = 500, message = "{Size.FineReportVo.comments}")
    private String comments;

    /** 目录标识 */
    @NotNull(message = "{NotNull.FineReportVo.folderId}")
    private Long folderId;

    /**
     * 目录名称
     */
    private String folderName;

    /** 报表顺序 */
    @NotNull(message = "{NotNull.FineReportVo.reportOrder}")
    @Max(value = 9999, message = "{Max.FineReportVo.reportOrder}")
    @Digits(integer = 5, fraction = 0, message = "{Digits.FineReportVo.reportOrder}")
    private Integer reportOrder;

    /** 报表创建时间 */
    private String createTime;

    /** 授权组织 */
    @Valid
    private List<BizObjAuthRelVo> org;

    /** 授权角色 */
    @Valid
    private List<BizObjAuthRelVo> role;

    /** 授权用户 */
    @Valid
    private List<BizObjAuthRelVo> user;

    /**
     * 是否配置人员 0:否; 1:是
     */
    @Range(min = 0, max = 1, message = "{Range.FineReportVo.userConfigFlag}")
    private Integer userConfigFlag;

    /**
     * 配置的部门标识 1：一级部门 2：二级部门 3：三级部门
     */
    @Range(min = 1, max = 3, message = "{Range.FineReportVo.departmentConfigFlag}")
    private Integer departmentConfigFlag;

    /**
     * 配置的工厂名称
     */
    private String factoryConfigName;
}