package com.digiwin.athena.semc.vo.portal;

import com.google.common.collect.Lists;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * 业务待办分组条件返回实体
 *
 * @author sunqgz
 * @since 2024-07-31
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class GroupRuleResp implements Serializable {

    private static final long serialVersionUID = -6586408026776159033L;

    /**
     * 业务待办分组名称
     */
    private String name;

    /**
     * 业务待办分组code
     */
    private String code;

    /**
     * 业务待办分组条件值
     */
    private List<GroupRuleResp> groupConditionList = Lists.newArrayList();
}