package com.digiwin.athena.semc.vo.portal;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 业务待办数返回实体
 *
 * @author sunqgz
 * @since 2024-08-01
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class GroupRuleValueResp implements Serializable {

    private static final long serialVersionUID = 499310810518616544L;

    /**
     * 分组条件code
     */
    private String groupCode;

    /**
     * 分组条件名称 三方应用返回字段，小AI不返回
     */
    private String groupName;

    /**
     * 分组条件值code
     */
    private String groupConditionCode;

    /**
     * 分组条件值名称 三方应用返回字段，小AI不返回
     */
    private String groupConditionName;

    /**
     * 源应用数据来源 1:b/s 表 2:c/s 表 3:预设表 4:IAM接口 5:虚拟应用
     */
    private Integer dataType;

    /**
     * 待办数
     */
    private Integer value;


    /**
     * 回调地址
     */
    private String callBackUrl;

    /**
     * 新增的应用id
     */
    private String applicationAppId;

    /**
     * 如果appToken不为空，则需要前端额外拼接在url后
     * 需要额外拼接的内容总共有userToken，dwLang，routerKey和appToken
     */
    private String appToken;

    /**
     * 协议类型 1、oauth2.0 2、cas
     */
    private Integer protocolType;

    /**
     * 应用类型 1:b/s应用 2:c/s应用
     */
    private Integer systemType;

    /**
     * 应用名称
     */
    private String appName;

    /**
     * 跳转链接
     */
    private String url;
}