package com.digiwin.athena.semc.vo.portal;

import lombok.*;
import java.io.Serializable;

/**
 * @description: 帆软报表导入结果返回对象
 * @createDate: 2023/8/14
 * @author: sungqz
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class ImportExcelResp implements Serializable {
    /**
     * 主键
     */
    private Long id;

    /**
     * 返回码 2001：全部成功 2002：部分成功 部分失败 2003：全部失败
     */
    private String resultCode = "2001";

    /**
     * 导入成功数量
     */
    private Integer successCount = 0;

    /**
     * 导入失败数量
     */
    private Integer failCount = 0;

    /**
     * 失败文件id
     */
    private String failFileId;

    /**
     * 失败文件名称
     */
    private String failFileName;

    /**
     * 失败文件链接
     */
    private String failFileUrl;
}