package com.digiwin.athena.semc.vo.portal;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import lombok.*;
import java.io.Serializable;

/**
 * @description: 帆软报表导入结果对象
 * @createDate: 2023/8/14
 * @author: sungqz
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class ImportExcelVo implements Serializable {

    /**
     * 报表名称
     */
    @ColumnWidth(20)
    @ExcelProperty(index = 0, value = "报表名称")
    private String name;

    /**
     * 描述
     */
    @ColumnWidth(20)
    @ExcelProperty(index = 1, value = "报表备注")
    private String comments;

    /**
     * 报表链接
     */
    @ColumnWidth(20)
    @ExcelProperty(index = 2, value = "报表链接")
    private String url;

    /**
     * 报表顺序
     */
    @ColumnWidth(20)
    @ExcelProperty(index = 3, value = "排序")
    private String reportOrder;

    /**
     * 一级目录名称
     */
    @ColumnWidth(20)
    @ExcelProperty(index = 4, value = "报表1级目录")
    private String firstFolderName;

    /**
     * 二级目录名称
     */
    @ColumnWidth(20)
    @ExcelProperty(index = 5, value = "报表2级目录")
    private String secondFolderName;

    /**
     * 三级目录名称
     */
    @ColumnWidth(20)
    @ExcelProperty(index = 6, value = "报表3级目录")
    private String thirdFolderName;

    /**
     * 失败原因
     */
    @ColumnWidth(20)
    @ExcelProperty(index = 7, value = "失败原因")
    private String failDesc;
}