package com.digiwin.athena.semc.vo.portal;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import lombok.*;

import java.io.Serializable;


/**
 * 组件权限导入结果
 *
 * @author sungqz
 * @since 2024-06-03
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class ImportLabelExcelVo implements Serializable {

    private static final long serialVersionUID = -7421213497317885313L;

    /**
     * 角色id或用户id
     */
    @ColumnWidth(20)
    @ExcelProperty(index = 0, value = "角色ID/用户ID")
    private String roleEmpId;

    /**
     * 组件名称
     */
    @ColumnWidth(20)
    @ExcelProperty(index = 1, value = "组件名称")
    private String labelName;

    /**
     * 组件来源 0：自定义组件 1：预设组件
     */
    @ColumnWidth(20)
    @ExcelProperty(index = 2, value = "组件来源")
    private String labelSource;

    /**
     * 失败原因
     */
    @ColumnWidth(20)
    @ExcelProperty(index = 3, value = "失败原因")
    private String failDesc;
}