package com.digiwin.athena.semc.vo.portal;

import com.digiwin.athena.semc.dto.portal.LabelSystemLinkParamDTO;
import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * 全部组件返回实体
 */
@Data
public class LabelSystemAllVo implements Serializable {

    private static final long serialVersionUID = -3738695722337470207L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 预设组件名称
     */
    private String name;

    /**
     * 预设组件名称-繁体
     */
    private String nameTw;

    /**
     * 组件分类（ 0-预设组件-三方待办、1-预设组件-三方报表、2-预设组件-新闻公告、5-预设组件-固定组件；）
     */
    private Integer dataCategory;

    /**
     * 数据类型（0：待办、1：三方报表、2：新闻公告、3：邮件、4：常用、5：收藏、6：全局资讯、7：绩效、8：作业工作台、9：行事历）
     */
    private Integer dataType;

    /**
     * 组件端 0:PC端，1:移动端
     */
    private Integer clientType;

    /**
     * 经典门户图标
     */
    private String classicsIcon;

    /**
     * 极简门户图标
     */
    private String icon;

    /**
     * 组件类型（0：自定义组件、1：预设组件、2：自定义菜单）
     */
    private Integer contentType;

    /**
     * 自定义组件分类  3-自定义组件-作业集成、4-自定义组件-应用集成、6-自定义组件-统计组件、7-自定义组件-业务待办、8-自定义组件-内嵌网页、9-自定义组件-报表、10-自定义组件-低代码
     */
    private List<Integer> dataCategoryList;

    /**
     * 预设组件分类 0：待办、1：三方报表、2：新闻公告、3：邮件、4：常用、5：收藏、6：数智视图、7：绩效、8：作业工作台、9：行事历、10：三方待办、11：轮播图
     */
    private List<Integer> preDateTypeList;

    /**
     * 有效状态 0:无效 1:有效
     */
    private Integer validStatus;

    /**
     * 主键id列表
     */
    private List<Long> idList;
    /**
     * 部件类型来源，0：租户部件，1：ISV部件
     */
    private Integer labelTypeSource;

    private Map<String, Object> contentConfig;

    private String modifyTime;

    /**
     * 内嵌网页-组件类型 完整链接地址
     */
    private String linkUrlFull;

    /**
     * 内嵌网页-组件类型 链接配置
     */
    private List<LabelSystemLinkParamDTO> linkParamList;

    private String linkParam;

    private String linkUrl;
}