package com.digiwin.athena.semc.vo.portal;

import com.baomidou.mybatisplus.annotation.TableField;
import com.digiwin.athena.semc.configuration.MySqlMapHandler;
import com.digiwin.athena.semc.service.workbench.designer.mongo.MultiLanguageDTO;
import com.google.gson.annotations.SerializedName;

import com.digiwin.athena.semc.dto.portal.LabelSystemLinkParamDTO;
import com.digiwin.athena.semc.entity.portal.LabelSystemCustom;
import com.digiwin.athena.semc.entity.temp.TemplateSystemCustom;

import java.util.List;
import java.util.Map;

import io.github.linpeilie.annotations.AutoMapper;
import io.github.linpeilie.annotations.AutoMappers;
import lombok.Data;

/**
 * @author CR-7
 * create: 2024-01-23 15:59
 * Description:
 */
@Data
@AutoMappers({
        @AutoMapper(target = LabelSystemCustom.class),
        @AutoMapper(target = TemplateSystemCustom.class)
})
public class LabelSystemCustomQueryVO {

    /**
     * 主键id
     */
    private Long id;

    /**
     * 自定义组件名称-中文
     */
    private String nameZh;

    /**
     * 自定义组件名称-英文
     */
    private String nameUs;

    /**
     * 图标
     */
    private String icon;

    /**
     * 经典门户图标
     */
    private String classicsIcon;

    /**
     * 组件分类（ 3-自定义组件-作业集成、4-自定义组件-应用集成）
     */
    private Integer dataCategory;

    /**
     * 内嵌网页-组件类型 链接地址
     */
    private String linkUrl;

    /**
     * 内嵌网页-组件类型 链接配置
     */
    private List<LabelSystemLinkParamDTO> linkParamList;

    /**
     * 内嵌网页-组件类型 完整链接地址
     */
    private String linkUrlFull;

    /**
     * 有效状态 0:无效 1:有效
     */
    private Integer validStatus;

    /**
     *  展示方式（ 0：文本列表、1：应用、2：应用作业）
     */
    private Integer showType;

    /**
     * 创建者登录账号
     */
    protected String createUserId;

    /**
     * 创建者登录名称
     */
    protected String createUserName;


    /**
     * 创建日期
     */
    protected String createTime;

    /**
     * 更新者登录名称
     */
    protected String modifyUserName;

    /**
     * 更新时间
     */
    private String modifyTime;


    /**
     * 更新人
     */
    private String modifyUserId;


    /**
     *  组件来源（ 0：自定义组件、1：预设组件）
     */
    private Integer componentSource;

    /**
     * 数据源备注
     */
    private String remark;

    /**
     * 组件关联数据源信息
     */
    private List<DataSourceInfo> dataSourceInfo;

    /**
     * 应用ID
     */
    private String appCode;

    /**
     * 应用主键ID
     */
    private String appSystemId;

    /**
     * 数据来源 1:b/s 表 2:c/s 表 3:预设表应用 4:IAM接口应用 5:虚拟应用
     */
    private Integer dataSource;

    /**
     * 应用名称
     */
    private String appName;

    /**
     * 账套ID
     */
    private String accountId;

    private String tenantId;

    /**
     * 工作台自定义部件设计时id
     */
    private String componentDesignerId;

    /**
     * 工作台应用code
     */
    private String workbenchAppCode;

    /**
     * 数据版本
     */
    private String version;

    /**
     * 编译版本，可选
     */
    private String compileVersion;

    /**
     * ISV客制部件的脚本
     */
    private Map<String, Object> contentConfig;

    /**
     * 多语言
     */
    private Map<String, MultiLanguageDTO> lang;

    /**
     * 内容
     */
    private String content;

    /**
     * 是否可编辑或者可删除  0 可编辑可删除 1不可编辑不可删除
     */
    private Integer status;

    private Integer source;


    @Data
    public static class DataSourceInfo {

        /**
         *  数据源ID
         */
        @SerializedName("data_id")
        private Long dataId;

        /**
         *  组件ID
         */
        @SerializedName("system_id")
        private Long systemId;

        /**
         *  组件来源（ 0：自定义组件、1：预设组件）
         */
        @SerializedName("component_source")
        private Integer componentSource;

        /**
         *  数据源名称
         */
        @SerializedName("name")
        private String name;

    }
}
