package com.digiwin.athena.semc.vo.portal;

import com.digiwin.athena.semc.dto.portal.LabelSystemDataDto;
import com.digiwin.athena.semc.entity.applink.TenantAppDTO;
import com.digiwin.athena.semc.entity.portal.PreinstalledApplication;
import com.digiwin.athena.semc.entity.portal.PreinstalledApplicationInstance;
import com.digiwin.athena.semc.entity.sso.ErpSsoInfo;
import com.digiwin.athena.semc.entity.sso.ThirdSsoInfo;
import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * bs/cs/预设/IAM 返回实体
 */
@Data
public class LabelSystemDataAppVo implements Serializable {

    /**
     * CS应用
     */
    private Map<Long, ErpSsoInfo> erpInfoMap;

    /**
     * 数据源中包含CS应用的数据源ID
     */
    private List<Long> erpSystemId;


    /**
     * BS应用
     */
    private Map<Long, ThirdSsoInfo> thirdSsoInfoMap;


    /**
     * 数据源中包含BS应用的数据源ID
     */
    private List<Long> bsSystemId;

    /**
     * 预设应用
     */
    private Map<Long, PreinstalledApplication> preInfoMap;


    /**
     * 数据源中包含预设应用的数据源ID
     */
    private List<Long> preSystemId;

    /**
     * 雅典娜应用
     */
    private Map<String, TenantAppDTO> athenaInfoMap;

    /**
     * 租户预设应用
     */
    private  PreinstalledApplicationInstance preInstance;


    /**
     * 数据源中源应用名称，key：数据源ID，val:源应用名称
     */
    private Map<Long, LabelSystemDataDto> systemAppNameMap;

}