package com.digiwin.athena.semc.vo.portal;

import com.google.gson.annotations.SerializedName;

import com.digiwin.athena.semc.entity.portal.LabelSystemPre;
import com.digiwin.athena.semc.entity.temp.TemplateSystemPre;

import java.util.List;

import io.github.linpeilie.annotations.AutoMapper;
import io.github.linpeilie.annotations.AutoMappers;
import lombok.Data;

/**
 * @author CR-7
 * create: 2024-01-23 15:59
 * Description:
 */
@Data
@AutoMappers({
        @AutoMapper(target = LabelSystemPre.class),
        @AutoMapper(target = TemplateSystemPre.class)
})
public class LabelSystemPreQueryVO {

    /**
     * 主键id
     */
    private Long id;

    /**
     * 预设组件名称
     */
    private String name;

    /**
     * 组件分类（ 0-预设组件-三方待办、1-预设组件-三方报表、2-预设组件-新闻公告、5-预设组件-固定组件；）
     */
    private Integer dataCategory;

    /**
     * 有效状态 0:无效 1:有效
     */
    private Integer validStatus;

    /**
     * 是否需要卡死状态为有效（0：不需要；1：需要）
     */
    private Integer isEnableTrue;

    /**
     * 是否需要选择数据源（0：不需要；1：需要）
     */
    private Integer isUseData;

    /**
     * 更新人
     */
    private String modifyUserId;

    /**
     * 更新时间
     */
    private String modifyTime;

    /**
     * 更新者登录名称
     */
    protected String modifyUserName;
    /**
     * 数据类型（0：待办、1：三方报表、2：新闻公告、3：邮件、4：常用、5：收藏、6：全局资讯、7：绩效、8：作业工作台、9：行事历）
     */
    private Integer dataType;

    /**
     *  组件来源（ 0：自定义组件、1：预设组件）
     */
    private Integer componentSource;


    /**
     * 组件关联数据源信息
     */
    private List<DataSourceInfo> dataSourceInfo;

    /**
     * 创建日期
     */
    protected String createTime;

    /**
     * 创建者登录账号
     */
    protected String createUserId;

    /**
     * 创建者登录名称
     */
    protected String createUserName;


    protected Integer clientType;



    @Data
    public static class DataSourceInfo {

        /**
         *  数据源ID
         */
        @SerializedName("data_id")
        private Long dataId;

        /**
         *  组件ID
         */
        @SerializedName("system_id")
        private Long systemId;

        /**
         *  组件来源（ 0：自定义组件、1：预设组件）
         */
        @SerializedName("component_source")
        private Integer componentSource;

        /**
         *  数据源名称
         */
        @SerializedName("name")
        private String name;

    }
}
