package com.digiwin.athena.semc.vo.portal;

import com.baomidou.mybatisplus.annotation.TableField;
import com.digiwin.athena.semc.entity.mobile.MobilePortalInfoAuth;
import com.digiwin.athena.semc.entity.portal.PortalInfoAuth;
import io.github.linpeilie.annotations.AutoMapper;
import io.github.linpeilie.annotations.AutoMappers;
import lombok.*;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 *布局权限
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class PortalInfoAuthReq implements Serializable {

    private static final long serialVersionUID = 6497000399827941640L;

    /**
     * 权限对象列表
     */
    @Valid
    private List<AuthVO> authList;


    /**
     * 门户主键id/ 设计时门户Id（portal_designer_id）
     */
    @NotNull(message = "id cannot be empty")
    private Long id;

    /**
     * 客户端类型 PC端：0，移动端：1
     * ClientTypeTypeEnum
     */
    @NotNull(message = "clientType cannot be empty")
    private Integer clientType;

    /**
     * 门户类型来源，0：租户门户，1：ISV门户
     */
    @NotNull(message = "portalTypeSource cannot be empty")
    private Integer portalTypeSource;


    /**
     * 权限
     */
    @Data
    @AutoMappers({
            @AutoMapper(target = PortalInfoAuth.class),
            @AutoMapper(target = MobilePortalInfoAuth.class)
    })
    public static class AuthVO {
        /**
         * 权限对象id
         */
        @NotNull(message = "{NotNull.BizObjAuthRelVo.authId}")
        private Long authId;

        /**
         * 权限类型：1.组织 2.角色 3.用户 5.部门
         */
        @NotNull(message = "{NotNull.BizObjAuthRelVo.authType}")
        private Integer authType;

        /**
         * 权限对象名称
         */
        @NotBlank(message = "{NotBlank.BizObjAuthRelVo.authName}")
        private String authName;
    }


}