package com.digiwin.athena.semc.vo.portal;

import com.baomidou.mybatisplus.annotation.TableField;
import com.digiwin.athena.semc.entity.portal.PortalInfo;

import java.io.Serializable;

import io.github.linpeilie.annotations.AutoMapper;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;
import org.springframework.data.mongodb.core.aggregation.ArrayOperators;

import javax.validation.constraints.NotNull;

/**
 *用户权限内职能布局
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
@AutoMapper(target = PortalInfo.class)
public class PortalUserAuthResp implements Serializable {

    private static final long serialVersionUID = 6497000399827941640L;

    /**
     * 门户主键
     */
    private Long id;
    /**
     * 门户类型来源，0：租户门户，1：ISV门户
     */
    private Integer portalTypeSource;

    /**
     * 客户端类型 PC端：0，移动端：1
     * ClientTypeTypeEnum
     */
    private Integer clientType;

    /**
     * 门户名称
     */
    private String name;

    /**
     * 默认标识 0:否 1:是
     */
    private Integer defaultFlag;

    /**
     * 是否是最近打开的门户；true：是、false：否
     */
    private Boolean isRecently;

    /**
     * 最近选择的门户权限不存在时提示信息，为空说明有权限或者第一次使用
     */
    private String recentlyMsg;

    /**
     * 是否是通用菜单模板 0:否 1:是
     */
    private Integer menuGeneralFlag = 0;

    /**
     * 菜单来源，0：租户菜单，1：ISV菜单
     */
    private Integer menuTypeSource;
    /**
     * 自定义菜单模板id
     */
    private Long menuTemplateId;

    /**
     * 0 没有改变  1 有改变
     */
    private Integer changed;

    /**
     * 老门户版本为0 默认门户版本为1
     */
    private int versionDefault;
}