package com.digiwin.athena.semc.vo.portal;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.NumberFormat;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.alibaba.excel.annotation.write.style.HeadRowHeight;
import lombok.*;

import java.io.Serializable;

/**
 * @description: 自定义组件导入模版信息
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class SystemCustomExportVo implements Serializable {

    /**
     * 自定义组件名称
     */
    @ColumnWidth(25)
    @ExcelProperty(index = 0, value = "自定义组件名称")
    private String nameZh;

    /**
     * 组件分类
     */
    @ColumnWidth(20)
    @ExcelProperty(index = 1, value = "组件分类")
    private String dataCategory;

    /**
     * 状态
     */
    @ColumnWidth(20)
    @ExcelProperty(index = 2, value = "状态")
    private String validStatus;

    /**
     * 数据源名称
     */
    @ColumnWidth(20)
    @ExcelProperty(index = 3, value = "数据源名称")
    @NumberFormat(value = "0")
    private String dataName;



    /**
     * 自定义组件备注
     */
    @ColumnWidth(20)
    @ExcelProperty(index = 4, value = "自定义组件备注")
    private String remark;

}