package com.digiwin.athena.semc.vo.portal;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.NumberFormat;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import lombok.*;

import java.io.Serializable;

/**
 * @description: 数据源导入模版信息
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class SystemDataExportVo implements Serializable {

    /**
     * 数据源名称
     */
    @ColumnWidth(20)
    @ExcelProperty(index = 0, value = "*数据源名称")
    @NumberFormat(value = "0")
    private String name;

    /**
     * 源应用
     */
    @ColumnWidth(20)
    @ExcelProperty(index = 1, value = "*源应用")
    @NumberFormat(value = "0")
    private String appName;

    /**
     * 数据源分类
     */
    @ColumnWidth(20)
    @ExcelProperty(index = 2, value = "*数据源分类")
    private String category;

    /**
     * 状态
     */
    @ColumnWidth(20)
    @ExcelProperty(index = 3, value = "*状态")
    private String validStatus;

    /**
     * 作业填写方式
     */
    @ColumnWidth(20)
    @ExcelProperty(index = 4, value = "作业填写方式")
    private String jobType;

    /**
     * 作业值
     */
    @ColumnWidth(20)
    @ExcelProperty(index = 5, value = "作业值")
    private String jobVal;

    /**
     * 数据源备注
     */
    @ColumnWidth(20)
    @ExcelProperty(index = 6, value = "数据源备注")
    private String remark;

}