package com.digiwin.athena.semc.vo.portal;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import lombok.*;

import java.io.Serializable;

/**
 * @description: 已集成的作业导出信息
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class SystemDataJobExportVo implements Serializable {

    /**
     * 应用名称
     */
    @ColumnWidth(20)
    @ExcelProperty(index = 0, value = "应用名称")
    private String appName;

    /**
     * 作业名称
     */
    @ColumnWidth(20)
    @ExcelProperty(index = 1, value = "作业名称")
    private String jobName;

    /**
     * 作业ID
     */
    @ColumnWidth(20)
    @ExcelProperty(index = 2, value = "作业ID")
    private String jobId;

}