package com.digiwin.athena.semc.vo.portal;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 校验自定义组件是否关联门户、菜单、作业工作台 返回对象
 *
 * @author sungqz
 * @since 2025-02-28
 */
@Data
public class ValidLabelRelVO implements Serializable {

    private static final long serialVersionUID = 7538389152307388846L;

    /**
     * 校验结果标识 false：校验失败 true：校验成功
     */
    private Boolean successFlag = Boolean.TRUE;

    /**
     * 是否关联了极简门户 false：否 true：是
     */
    private Boolean simpleRelFlag = Boolean.FALSE;

    /**
     * 经典门户名称列表
     */
    private List<String> classicalNameList;

    /**
     * 自定义菜单模板名称列表
     */
    private List<String> menuNameList;

    /**
     * 作业工作台名称列表
     */
    private List<String> jobBenchNameList;
}