package com.digiwin.athena.semc.vo.temp;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.NumberFormat;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import lombok.*;

import java.io.Serializable;

/**
 * @description: 工作台导入模版信息
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class TemplateBenchExportVo implements Serializable {

    /**
     * 模版名称
     */
    @ColumnWidth(20)
    @ExcelProperty(index = 0, value = "职能作业工作台名称")
    private String benchName;

    /**
     * 泳道名称
     */
    @ColumnWidth(20)
    @ExcelProperty(index = 1, value = "泳道名称")
    private String laneName;

    /**
     * 作业名称
     */
    @ColumnWidth(20)
    @ExcelProperty(index = 2, value = "作业名称")
    @NumberFormat(value = "0")
    private String jobName;


}