package com.digiwin.athena.semc.vo.temp;

import com.digiwin.athena.semc.entity.base.BaseEntity;
import com.digiwin.athena.semc.entity.temp.TemplateBench;
import com.digiwin.athena.semc.entity.temp.TemplateInfo;

import java.io.Serializable;
import java.util.List;

import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;

/**
 * ISV作业工作台模版信息
 */
@Data
@AutoMapper(target = TemplateInfo.class)
public class TemplateBenchVO extends BaseEntity<TemplateBenchVO> implements Serializable {

    /**
     * 工作台ID
     */
    private Long id;

    /**
     * 模版ID
     */
    private Long templateId;


    /**
     * 模版编号
     */
    private String templateNo;

    /**
     * 模版排序
     */
    private Integer templateSort;

    /**
     * 模版名称
     */
    private String templateName;

    /**
     * 描述
     */
    private String templateDesc;

    /**
     * 状态（0：未发布；1：已发布）
     */
    private Integer status;

    /**
     * 模版类型（0：经典门户、1：作业工作台、2：自定义菜单）
     */
    private Integer templateType;

    /**
     * 订阅的类型（0：全部租户、1：部分租户、2：不选择租户）
     */
    private Integer subType;

    /**
     * 租户id
     */
    private String tenantId;

    /**
     * 创建者登录名称
     */
    protected String createUserName;

    /**
     * 更新者登录名称
     */
    protected String modifyUserName;


    /**
     *部分租户集合，subType=1时返回
     */
    private List<TemplateTenantVO> subTenantList;

    /**
     *分组集合，subType=1时返回
     */
    private List<TemplateTenantGroupVO> groupList;

    /**
     * 泳道集合
     */
    private List<TemplateBench> laneList;

}