package com.digiwin.athena.semc.vo.temp;

import com.digiwin.athena.semc.entity.base.BaseEntity;
import com.digiwin.athena.semc.entity.portal.PortalInfoContent;
import com.digiwin.athena.semc.entity.temp.TemplatePortalInfo;
import com.digiwin.athena.semc.entity.temp.TemplatePortalInfoContent;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;
import java.util.List;

/**
 * ISV门户模版信息
 */
@Data
@AutoMapper(target = TemplatePortalInfo.class)
public class TemplatePortalVO extends BaseEntity<TemplatePortalVO> implements Serializable {

    /**
     * 门户id
     */
    private Long id;

    /**
     * 模版ID
     */
    private Long templateId;

    /**
     * 默认标识 0:否 1:是
     */
    private Integer defaultFlag;

    /**
     * 门户名称
     */
    private String name;

    /**
     * 门户描述
     */
    private String portalDesc;

    /**
     * 自定义菜单模板id
     */
    private Long menuTemplateId;

    /**
     * 是否是通用菜单模板 0:否 1:是
     */
    private Integer menuGeneralFlag = 0;

    /**
     * 布局状态（0：未发布；1：已发布）
     */
    private Integer status;

    /**
     * 布局内容
     */
    private String portalContent;

    /**
     * 缩略图文件id
     */
    private String portalImgId;


    /**
     * 订阅的类型（0：全部租户、1：部分租户、2：不选择租户）
     */
    private Integer subType;


    /**
     * 租户id
     */
    private String tenantId;

    /**
     * 创建者登录名称
     */
    protected String createUserName;

    /**
     * 更新者登录名称
     */
    protected String modifyUserName;


    /**
     * 内容集合
     */
    private List<TemplatePortalInfoContent> contentList;


    /**
     *部分租户集合，subType=1时返回
     */
    private List<TemplateTenantVO> subTenantList;

    /**
     *分组集合，subType=1时返回
     */
    private List<TemplateTenantGroupVO> groupList;

}