/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.aspect;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.semc.annotate.MenuPermissionAuth;
import com.digiwin.athena.semc.mapper.menu.manage.ManageMenuAuthMapper;
import com.digiwin.athena.semc.proxy.iam.service.IamService;
import com.digiwin.athena.semc.proxy.iam.service.model.RoleDTO;
import com.digiwin.athena.semc.proxywrapper.IamUserService;
import com.digiwin.athena.semc.proxywrapper.dto.IamUserAuthInfo;
import com.digiwin.athena.semc.util.Utils;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class MenuPermissionAuthAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MenuPermissionAuthAspect.class);
    @Resource
    private IamService iamService;
    @Resource
    private IamUserService iamUserService;
    @Resource
    private ManageMenuAuthMapper manageMenuAuthMapper;

    @Pointcut(value="@within(com.digiwin.athena.semc.annotate.MenuPermissionAuth) || @annotation(com.digiwin.athena.semc.annotate.MenuPermissionAuth)")
    public void permissionAuthAspect() {
        log.info(" ---------- MenuPermissionAuthAspect()");
    }

    @Before(value="permissionAuthAspect()")
    public void mgrPermissionAuthCheck(JoinPoint joinPoint) {
        MenuPermissionAuth permissionAuth = null;
        try {
            Class<?> clazz = joinPoint.getTarget().getClass();
            if (clazz.isAnnotationPresent(MenuPermissionAuth.class)) {
                permissionAuth = clazz.getAnnotation(MenuPermissionAuth.class);
            } else {
                MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
                Method method = methodSignature.getMethod();
                if (method.isAnnotationPresent(MenuPermissionAuth.class)) {
                    permissionAuth = method.getDeclaredAnnotation(MenuPermissionAuth.class);
                }
            }
        }
        catch (Exception e) {
            log.error("permissionAuthAspect error", (Throwable)e);
            return;
        }
        if (permissionAuth == null || StringUtils.isBlank((CharSequence)permissionAuth.code())) {
            return;
        }
        this.menuPermissionAuth(permissionAuth);
    }

    private void menuPermissionAuth(MenuPermissionAuth permissionAuth) {
        try {
            List roles = this.iamService.queryUserRoles(Utils.getUserId(), Utils.getUserToken());
            for (RoleDTO role : roles) {
                if (!Objects.equals(role.getId(), permissionAuth.role())) continue;
                return;
            }
        }
        catch (Exception e) {
            log.error("menuPermissionAuth role auth error", (Throwable)e);
        }
        this.menuAuth(permissionAuth.code());
    }

    private void menuAuth(String menuKey) {
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        IamUserAuthInfo iamUserAuthInfo = this.iamUserService.getUserAuthSids(authoredUser.getUserId(), authoredUser.getTenantId(), authoredUser.getToken());
        ArrayList authIdList = Lists.newArrayList();
        if (Objects.nonNull(iamUserAuthInfo)) {
            if (CollectionUtils.isNotEmpty((Collection)iamUserAuthInfo.getOrgSids())) {
                authIdList.addAll(iamUserAuthInfo.getOrgSids());
            }
            if (CollectionUtils.isNotEmpty((Collection)iamUserAuthInfo.getRoleSids())) {
                authIdList.addAll(iamUserAuthInfo.getRoleSids());
            }
            if (CollectionUtils.isNotEmpty((Collection)iamUserAuthInfo.getDeptSids())) {
                authIdList.addAll(iamUserAuthInfo.getDeptSids());
            }
        }
        if (ObjectUtils.isNotEmpty((Object)authoredUser.getSid())) {
            authIdList.add(authoredUser.getSid());
        }
        if (CollectionUtils.isNotEmpty((Collection)authIdList)) {
            Collections.sort(authIdList);
            QueryWrapper condition = new QueryWrapper();
            condition.eq((Object)"menu_key", (Object)menuKey);
            condition.apply("(auth_id IN ({0}) OR all_menu_auth_flag = {1})", new Object[]{Joiner.on((String)",").join((Iterable)authIdList), 1});
            Long selectCount = this.manageMenuAuthMapper.selectCount((Wrapper)condition);
            if (Objects.isNull(selectCount) || selectCount < 1L) {
                throw BusinessException.create((String)"No menu permission");
            }
        }
        throw BusinessException.create((String)"No menu permission");
    }
}

